bl_info = {
    "name": "Generador de G-Code para corte en CNC Popular",
    "author": "CNC Popular",
    "version": (0, 1, 0, 0),
    "blender": (4, 2, 0),
    "location": "View3D > Sidebar > Corte GCode",
    "description": "Exporta G-code para corte a partir de dibujo DXF con compensación, pestañas, Z optimizado y encabezado técnico",
    "category": "Import-Export",
}

import importlib
from . import utils, operators, panel

modules = [utils, operators, panel]
for m in modules:
    importlib.reload(m)

import bpy

classes = (
    *utils.classes,
    *operators.classes,
    *panel.classes,
)

def register():
    for cls in classes:
        bpy.utils.register_class(cls)
    bpy.types.Scene.cnc_props = bpy.props.PointerProperty(type=utils.CNCProperties)

def unregister():
    for cls in reversed(classes):
        bpy.utils.unregister_class(cls)
    if hasattr(bpy.types.Scene, "cnc_props"):
        del bpy.types.Scene.cnc_props

import sys, os

addon_dir = os.path.dirname(__file__)
libs_dir = os.path.join(addon_dir, "libs")
if libs_dir not in sys.path:
    sys.path.append(libs_dir)

try:
    import shapely
except ImportError as e:
    print("Error: Shapely no se pudo cargar desde libs/", e)
